
%% this is a sample code for the video saliency detection. Please cite the following papers when using the code.
%% 	Yuming Fang, Zhou Wang, Weisi Lin, and Zhijun Fang, Video Saliency Incorporating Spatiotemporal Cues and 
%% Uncertainty Weighting. IEEE Transactions on Image Processing 23(9), 3910-3921, 2014.
%%
%% Yuming Fang, Weisi Lin, Zhenzhong Chen, Chia-Ming Tsai, and Chia-Wen Lin, A Video Saliency Detection Model 
%% in Compressed Domain. IEEE Trans. Circuits Syst. Video Techn. 24(1): 27-38, 2014.

%% the static saliency is calculated by the following publication.
%% Yuming Fang, Zhenzhong Chen, Weisi Lin, Chia-Wen Lin: Saliency Detection in the Compressed Domain 
%% for Adaptive Image Retargeting. IEEE Transactions on Image Processing 21(9): 3888-3901 (2012)

%% please note that we use the source code of optical flow from the following publication.
%%  Sun, D.; Roth, S. & Black, M. J. "Secrets of Optical Flow Estimation and
%%   Their Principles" IEEE Int. Conf. on Comp. Vision & Pattern Recognition, 2010 


clear all
clc

addpath(genpath('./static_smap/'));
addpath(genpath('./motion_smap/'));
img_file1 = './image_seqs/426.jpg';
img_file2 = './image_seqs/427.jpg';


img1 = imread(img_file1);
img2 = imread(img_file2);
original_img = rgb2gray(img2);

%% motion saliency calculation
m_smap = Motion_Smap(img1, img2);

%% static saliency calculation
s_smap = Static_Smap(img2);
% imshow(m_smap);
% imshow(s_smap);

s_weighting_map = addition_uncertainty_weighting(s_smap);
%% Please add the global motion if you want to consider it.
global_motion = 0;
m_weighting_map = motion_uncertianty_weighting(original_img, global_motion, m_smap);
    
spatio_temporal_smap = s_smap.*m_weighting_map + m_smap.*s_weighting_map;
spatio_temporal_smap = mat2gray(spatio_temporal_smap);
spatio_temporal_smap = norm_operation(spatio_temporal_smap);
    
spatio_temporal_smap_enhance = s_smap.*m_weighting_map + m_smap.*s_weighting_map + s_smap.*m_smap;
spatio_temporal_smap_enhance = mat2gray(spatio_temporal_smap_enhance);
spatio_temporal_smap_enhance = norm_operation(spatio_temporal_smap_enhance);

figure(1)
imshow(s_smap);
title('satatic smap');
imwrite(s_smap, 'static_smap.jpg');

figure(2)
imshow(m_smap);
title('motion smap')
imwrite(m_smap, 'motion_smap.jpg');

figure(3)
imshow(spatio_temporal_smap);
title('spatiotemporal smap');
imwrite(spatio_temporal_smap, 'spatio_temporal_smap.jpg');

figure(4)
imshow(spatio_temporal_smap_enhance);
title('spatiotemporal smap with enhancement');
imwrite(spatio_temporal_smap_enhance, 'spatio_temporal_smap_enhance.jpg');